s=%s ;
T=syslin('c',25,25+4*s+s^2);
t=0:0.0005:5;
Ts=csim('step',t,T);
plot2d(t,Ts);
xgrid;
xtitle('Response of II order fn to unit-step input for T(s)=25/(s^2+6s+25)','Time(sec)',' C (t) ')
y=denom(T)                   // extracting the denominator of CL
z=coeff(y)      //extracting the coefficients of the denominator polynomial
                //Wn^2= z(1,1), comparing the coefficients
Wn=sqrt(z(1,1))          // Wn= natural frequency // 2 * zeta * Wn = z(1,2)
zeta=z(1,2)/(2*Wn)                  // zeta = d a m p i n g f a c t o r
Wd=Wn*sqrt(1-zeta^2)
Tp=%pi/Wd                                  // Tp= p e a k t i m e
Mp=100*exp((-%pi*zeta)/sqrt(1-zeta^2))     // Mp=p e a k o v e r s h o o t
Td=(1+0.7*zeta)/Wn                        // Td= d e l a y t i m e
a=atan(sqrt(1-zeta^2)/zeta)
Tr=(%pi-a)/Wd                             // T r = r i s e t i m e
Tset=4/(zeta*Wn)                            // T s = s e t t l i n g t i m e
            
Peak_time = sprintf("Peak Time = %6.3f secs",Tp);
Peak_overshoot = sprintf("Peak Overshoot = %6.3f percent",Mp);
Delay_time = sprintf("Delay_time = %6.3f secs",Td);
Rise_time = sprintf("Rise_time = %6.3f secs",Tr);
Settling_time = sprintf("Settling_time = %6.3f secs",Tset);

messagebox([Peak_overshoot,Peak_time,Delay_time,Rise_time,Settling_time],"Time response quantities");
